/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class IllagerAdditionsConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> samurai_raid_spawning;
    public static final ForgeConfigSpec.ConfigValue<Boolean> special_samurai_raid_spawning;
    public static final ForgeConfigSpec.ConfigValue<Boolean> shogun_raid_spawning;
    public static final ForgeConfigSpec.ConfigValue<Boolean> cowboy_raid_spawning;
    public static final ForgeConfigSpec.ConfigValue<Boolean> guard_raid_spawning;
    public static final ForgeConfigSpec.ConfigValue<Boolean> blastioner_raid_spawning;
    public static final ForgeConfigSpec.ConfigValue<Boolean> long_axeman_raid_spawning;
    public static final ForgeConfigSpec.ConfigValue<Integer> samurai_ai_strength;
    public static final ForgeConfigSpec.ConfigValue<Integer> guard_ai_strength;
    public static final ForgeConfigSpec.ConfigValue<Integer> cowboy_ai_strength;
    public static final ForgeConfigSpec.ConfigValue<Integer> shogunAttackDamageMultiplier;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> samuraiWaveCounts;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> shogunWaveCounts;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> guardWaveCounts;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> blastionerWaveCounts;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> longAxemanWaveCounts;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> cowboyWaveCounts;

    static {
        BUILDER.push("Config");
        BUILDER.comment("Combat Configurations");
        samurai_ai_strength = BUILDER.comment("Controls the Samurai ai strength, usually set to 1 \n0 = easy, 1 = normal, 2 = hard, 3 = hardest").define("Samurai ai strength", (Object)1);
        cowboy_ai_strength = BUILDER.comment("Controls the Cowboy ai strength, usually set to 1 \n0 = easy, 1 = normal, 2 = hard, 3 = hardest").define("Cowboy ai strength", (Object)1);
        guard_ai_strength = BUILDER.comment("Controls the Guard ai strength, usually set to 1 \n0 = easy, 1 = normal, 2 = hard, 3 = hardest").define("Guard ai strength", (Object)1);
        shogunAttackDamageMultiplier = BUILDER.comment("Controls the Shogun Attack Damage Multiplier, usually set to 1 \n0 = easy, 1 = normal, 2 = hard, 3 = hardest").define("Shogun Attack Damage Multiplier", (Object)1);
        BUILDER.pop();
        BUILDER.comment("Raids Configurations");
        shogun_raid_spawning = BUILDER.comment("Controls whether the Shogun spawns in raids, usually set to true").define("Shogun Raid Spawning", true);
        samurai_raid_spawning = BUILDER.comment("Controls whether the Samurai spawns in raids, usually set to true").define("Samurai Raid Spawning", true);
        special_samurai_raid_spawning = BUILDER.comment("Controls whether the special Samurai spawns in raids, usually set to true").define("Special Samurai Raid Spawning", true);
        guard_raid_spawning = BUILDER.comment("Controls whether the Guard spawns in raids, usually set to true").define("Guard Raid Spawning", true);
        blastioner_raid_spawning = BUILDER.comment("Controls whether the Blastioner spawns in raids, usually set to true").define("Blastioner Raid Spawning", true);
        long_axeman_raid_spawning = BUILDER.comment("Controls whether the Royal Guards spawns in raids, usually set to false").define("Royal Guards Raid Spawning", true);
        cowboy_raid_spawning = BUILDER.comment("Controls whether the Cowboy spawns in raids, usually set to true").define("Cowboy Raid Spawning", false);
        BUILDER.push("Raid Wave Member Configuration");
        shogunWaveCounts = BUILDER.comment("    Shogun Wave Counts\n    Requires a list of no more and less than 8 integers, each corresponding to its respective wave.\n").defineList("Shogun Wave Count", Arrays.asList(0, 0, 0, 0, 0, 0, 0, 1), s -> s instanceof Integer);
        samuraiWaveCounts = BUILDER.comment("    Samurai Wave Counts\n    Requires a list of no more and less than 8 integers, each corresponding to its respective wave.\n").defineList("Samurai Wave Counts", Arrays.asList(0, 1, 2, 0, 3, 1, 2, 4), s -> s instanceof Integer);
        guardWaveCounts = BUILDER.comment("    Guard Wave Counts\n    Requires a list of no more and less than 8 integers, each corresponding to its respective wave.\n").defineList("Guard Wave Counts", Arrays.asList(0, 1, 1, 0, 2, 1, 1, 2), s -> s instanceof Integer);
        blastionerWaveCounts = BUILDER.comment("    Blastioner Wave Counts\n    Requires a list of no more and less than 8 integers, each corresponding to its respective wave.\n").defineList("Blastioner Wave Counts", Arrays.asList(0, 0, 0, 0, 0, 1, 0, 1), s -> s instanceof Integer);
        longAxemanWaveCounts = BUILDER.comment("    Knights Wave Counts\n    Requires a list of no more and less than 8 integers, each corresponding to its respective wave.\n").defineList("Royal Guards Wave Counts", Arrays.asList(0, 0, 0, 0, 1, 0, 1, 1), s -> s instanceof Integer);
        cowboyWaveCounts = BUILDER.comment("    Cowboy Wave Counts\n    Requires a list of no more and less than 8 integers, each corresponding to its respective wave.\n").defineList("Cowboy Wave Counts", Arrays.asList(0, 1, 0, 1, 0, 1, 0, 1), s -> s instanceof Integer);
        SPEC = BUILDER.build();
    }
}

